/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.EnabledListCellRenderer;
import edu.princeton.swing.PHyperlink;
import edu.princeton.swing.PList;
import edu.princeton.swing.PScrollablePanel;
import edu.princeton.swing.PTextField;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TStdinPane
extends JPanel {
    private static final String CLASS_STRING = TStdinPane.class.toString();
    public static final String ADD_COMMAND = CLASS_STRING + "#addCommand";
    public static final String REMOVE_COMMAND = CLASS_STRING + "#removeCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private PTextField inputField;
    private ListModel consumedListModel;
    private ListModel unconsumedListModel;
    private ListSelectionModel unconsumedSelectionModel;
    private TWordBuffer oldConsumedStdin;
    private TWordBuffer newConsumedStdin;
    private TWordBuffer oldUnconsumedStdin;
    private TWordBuffer newUnconsumedStdin;
    private JButton addButton;
    private JButton removeButton;
    private PHyperlink openLink;
    private PHyperlink saveAsLink;
    private TVirtualMachine virtualMachine;
    private Runner runner;
    private Listener listener;

    public TStdinPane(TVirtualMachine virtualMachine, Action openStdinAction, Action saveStdinAction, boolean allowBlink) {
        super(new GridBagLayout(), true);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.oldConsumedStdin = new TWordBuffer();
        this.newConsumedStdin = new TWordBuffer();
        this.oldUnconsumedStdin = new TWordBuffer();
        this.newUnconsumedStdin = new TWordBuffer();
        if (allowBlink) {
            this.runner = new Runner();
        }
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.inputField = new PTextField(16);
        this.inputField.setFont(null);
        this.inputField.addActionListener(this.listener);
        this.inputField.setActionCommand(ADD_COMMAND);
        if (allowBlink) {
            this.inputField.addMouseListener(this.listener);
        }
        this.add((Component)this.inputField, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.addButton = new JButton("Add");
        this.addButton.setActionCommand(ADD_COMMAND);
        this.addButton.addActionListener(this.listener);
        this.add((Component)this.addButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Stdin"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.openLink = new PHyperlink(openStdinAction, 3);
        this.openLink.setText("Open...");
        this.add((Component)this.openLink, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.saveAsLink = new PHyperlink(saveStdinAction, 3);
        this.saveAsLink.setText("Save As...");
        this.add((Component)this.saveAsLink, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand(REMOVE_COMMAND);
        this.removeButton.addActionListener(this.listener);
        this.add((Component)this.removeButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        PScrollablePanel listPanel = new PScrollablePanel(new GridBagLayout());
        listPanel.setFont(null);
        this.consumedListModel = new ListModel();
        PList list = new PList((javax.swing.ListModel)this.consumedListModel);
        list.setEnabled(false);
        list.setFont(null);
        listPanel.add((Component)list, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.unconsumedListModel = new ListModel();
        list = new PList((javax.swing.ListModel)this.unconsumedListModel);
        list.setFont(null);
        this.unconsumedSelectionModel = list.getSelectionModel();
        listPanel.add((Component)list, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        Object[] data = new Object[]{"(Prompt)"};
        PList list2 = new PList(data);
        list2.setEnabled(false);
        list2.setFont(null);
        list2.setCellRenderer(new EnabledListCellRenderer());
        listPanel.add((Component)list2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(listPanel, 22, 30);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        this.add((Component)scrollPane, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == ADD_COMMAND) {
            this.virtualMachine.getUnconsumedStdin(this.newUnconsumedStdin);
            String string = this.inputField.getText();
            int length = string.length();
            this.inputField.setText("");
            int charCtr = 0;
            while (charCtr < length) {
                char ch = string.charAt(charCtr);
                if (TWord.isHexDigit(ch)) {
                    int peekCtr;
                    for (peekCtr = charCtr + 1; peekCtr < length && peekCtr < charCtr + 4 && TWord.isHexDigit(string.charAt(peekCtr)); ++peekCtr) {
                    }
                    try {
                        this.newUnconsumedStdin.add(TWord.parseWord(string.substring(charCtr, peekCtr), 16));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    charCtr = peekCtr;
                    continue;
                }
                ++charCtr;
            }
            this.unconsumedSelectionModel.clearSelection();
            this.virtualMachine.setStdin(null, this.newUnconsumedStdin);
            return true;
        }
        if (command == REMOVE_COMMAND) {
            if (this.unconsumedSelectionModel.isSelectionEmpty()) {
                return true;
            }
            this.newUnconsumedStdin.clear();
            int size = this.oldUnconsumedStdin.getSize();
            for (int ctr = 0; ctr < size; ++ctr) {
                if (this.unconsumedSelectionModel.isSelectedIndex(ctr)) continue;
                this.newUnconsumedStdin.add(this.oldUnconsumedStdin.getWord(ctr));
            }
            this.unconsumedSelectionModel.clearSelection();
            this.virtualMachine.setStdin(null, this.newUnconsumedStdin);
            return true;
        }
        if (command == UPDATE_COMMAND) {
            boolean isRunning;
            this.virtualMachine.getConsumedStdin(this.newConsumedStdin);
            this.virtualMachine.getUnconsumedStdin(this.newUnconsumedStdin);
            if (!this.newConsumedStdin.equals(this.oldConsumedStdin)) {
                this.consumedListModel.setData(this.newConsumedStdin);
            }
            if (!this.newUnconsumedStdin.equals(this.oldUnconsumedStdin)) {
                this.unconsumedListModel.setData(this.newUnconsumedStdin);
            }
            TWordBuffer temp = this.oldConsumedStdin;
            this.oldConsumedStdin = this.newConsumedStdin;
            this.newConsumedStdin = temp;
            temp = this.oldUnconsumedStdin;
            this.oldUnconsumedStdin = this.newUnconsumedStdin;
            this.newUnconsumedStdin = temp;
            if (this.runner != null && this.virtualMachine.needsInput()) {
                this.runner.start();
            }
            this.addButton.setEnabled(!(isRunning = this.virtualMachine.isRunning()));
            this.removeButton.setEnabled(!isRunning);
            this.inputField.setEnabled(!isRunning);
            return true;
        }
        throw new IllegalArgumentException();
    }

    protected static class ListModel
    extends AbstractListModel {
        private String[] data = new String[100];
        private int size;

        @Override
        public Object getElementAt(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.data[index];
        }

        @Override
        public int getSize() {
            return this.size;
        }

        protected void setData(TWordBuffer buffer) {
            int newSize;
            int oldSize = this.size;
            this.size = newSize = buffer.getSize();
            if (this.data.length < newSize) {
                this.data = new String[newSize * 2];
            }
            for (int ctr = 0; ctr < newSize; ++ctr) {
                this.data[ctr] = buffer.getWord(ctr).toString(false);
            }
            if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
                if (oldSize > 0) {
                    this.fireContentsChanged(this, 0, oldSize - 1);
                }
            } else if (oldSize == newSize) {
                if (newSize > 0) {
                    this.fireContentsChanged(this, 0, newSize - 1);
                }
            } else {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
                if (newSize > 0) {
                    this.fireContentsChanged(this, 0, newSize - 1);
                }
            }
        }
    }

    protected class Runner
    implements Runnable {
        int count;
        Thread runningThread;

        protected Runner() {
        }

        protected synchronized void start() {
            if (this.runningThread == null) {
                this.count = 0;
                this.runningThread = new Thread(this);
                this.runningThread.start();
            } else {
                this.count = 0;
            }
        }

        protected synchronized void stop() {
            this.count = 0x7FFFFFFE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Thread.currentThread() != this.runningThread) {
                throw new IllegalStateException();
            }
            boolean done = false;
            boolean colorBackground = false;
            Color originalBackground = TStdinPane.this.inputField.getBackground();
            Runner runner = this;
            synchronized (runner) {
                if (this.count >= 3) {
                    done = true;
                    TStdinPane.this.inputField.setBackground(originalBackground);
                    TStdinPane.this.inputField.repaint();
                    this.runningThread = null;
                }
            }
            while (!done) {
                boolean bl = colorBackground = !colorBackground;
                if (colorBackground) {
                    TStdinPane.this.inputField.setBackground(TStdinPane.this.inputField.getSelectionColor());
                } else {
                    TStdinPane.this.inputField.setBackground(originalBackground);
                }
                TStdinPane.this.inputField.repaint();
                try {
                    Thread.sleep(300L);
                    if (colorBackground) {
                        ++this.count;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.count = 0x7FFFFFFE;
                }
                runner = this;
                synchronized (runner) {
                    if (this.count >= 3) {
                        done = true;
                        TStdinPane.this.inputField.setBackground(originalBackground);
                        TStdinPane.this.inputField.repaint();
                        this.runningThread = null;
                    }
                }
            }
        }
    }

    protected class Listener
    implements ActionListener,
    ChangeListener,
    MouseListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TStdinPane.this.doCommand(e.getActionCommand(), null);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TStdinPane.this.doCommand(UPDATE_COMMAND, null);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TStdinPane.this.runner.stop();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

